package com.example.android.test;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.Socket;

import android.app.Activity;
import android.content.Context;
import android.os.AsyncTask;
import android.os.Bundle;
import android.view.Menu;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;
import android.widget.TextView;

/**
 * Android application that communicates with a Server.  Note the similarities between this example and the example in pure Java.
 * 
 * @author Marc J. McDougall
 */
public class Main extends Activity 
{
	
    @Override
    public void onCreate(Bundle savedInstanceState) 
    {
    	//Must be called at the start of each of the activity life-cycle calls
    	super.onCreate(savedInstanceState);
    	
    	//Set the content view equal to the resource main found in the res/layout/ folder.
    	setContentView(R.layout.main);
    	
    	//Get references to the Button and TextView objects in the form.
    	Button b = (Button) findViewById(R.id.send);
    	TextView t = (TextView) findViewById(R.id.text);
    	
    	//Get a reference to the embedded class NetworkInterface (explained later).  Pass in the TextView that is to be manipulated.
    	final NetworkInterface network = new NetworkInterface(t);
    	
    	//Set a ClickListener on the Button that determines what must be done when this object is clicked.  Then, instantiate a new OnClickListener to handle the 
    	// event.
    	b.setOnClickListener(new OnClickListener() {
			
			public void onClick(View v) {
				
				//Call the execute method of the embedded class.
				network.execute(Main.this);
			}
		});
    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu) 
    {
    	//This is unused in our simple application.
        getMenuInflater().inflate(R.menu.main, menu);
        return true;
    }
}

/**
 * Network interface that encapsulates all the Networking functionality of our application.  Note that this class extends AsyncTask, which
 * is a utility provided in the Android SDK that allows developers to post tasks to be done in the background.  See developer.android.com for an in-depth
 * explanation of this utility.
 * 
 * @author Marc J. McDougall
 */
class NetworkInterface extends AsyncTask<Context, Void, String>
{
	//Variable used to keep a reference to the Context of the Application
	Context con;
	
	//The shared TextView that will be updated for the user when the Network operation is successful.
	TextView t;
	
	//The socket that will be used to communicate with the server.
	Socket s;
	
	//The streams that will be sending data back and forth.
	ObjectOutputStream out;
	ObjectInputStream in;
	
	//Variable that will be used to change the value of t above (the TextView)
	String output;
	
	/**
	 * Default constructor.  Used to build a basic NetworkInterface.
	 * 
	 * @param t The Textview that should be modified after the Server has been contacted.
	 */
	public NetworkInterface(TextView t){
		
		this.t = t;
	}
	
	/**
	 * Called when the execute() method is called in the parent activity (see line 49 above)
	 */
	protected String doInBackground(Context... params) {
		
		//The context of the application will be passed as the first parameter here (at slot 0).
		con = params[0];
		
			try{
			
				//Initialize a new Socket by passing in the Server's *private* IP address, and the desired port.  Note that you must add your
				// own computers' private IP address in place of "localhost" here.
				s = new Socket("localhost", 2000);
				
//				DEBUG OUTPUT
				System.out.println("**Socket Established**");
				
				//Establish input and output streams for the connection
				out = new ObjectOutputStream(s.getOutputStream());
				in = new ObjectInputStream(s.getInputStream());
				
//				DEBUG OUTPUT
				System.out.println("**Streams Established**");
				
				//Write the String "Message" to the stream.
				out.writeObject("Message");
				
//				DEBUG OUTPUT
				System.out.println("**Waiting For Server Reply...**");
				
				//Toasts that the server has received and replied.  Note that this will block for input from the Server.  This is why it is in an AsyncTask
				// instead of on the main thread.
				output = (String) in.readObject();
			}
			catch(ClassNotFoundException e){
				
				//Do nothing here, just print the stack trace.
				e.printStackTrace();
			}
			catch(IOException e){
				
				//Do nothing here, just print the stack trace.
				e.printStackTrace();
			}
		
		//Return the String for the AsyncTask to handle in onPostExecute() below
		return output;
	}
	
	/**
	 * Called when the task in the Background has completed.
	 */
	protected void onPostExecute(String result){
		
		//Simply set the text of the shared TextView to be equal to the uppercase version of the message sent above.
		t.setText(result);
	}
}
